/* Linker script to configure memory regions.
 * Need modifying for a specific board.
 *   FLASH.ORIGIN: starting address of flash
 *   FLASH.LENGTH: length of flash
 *   RAM.ORIGIN: starting address of RAM bank 0
 *   RAM.LENGTH: length of RAM bank 0
 */
MEMORY
{
  BOOT_CFG (rx) : ORIGIN = 0x1F000000, LENGTH = 0x800 /* 2KB boot config area */
  SECOND_LVL_BTL (rx): ORIGIN = 0x1F000800, LENGTH = 0x400 /* 1KB 2nd level bootloader */
  FLASH (rx) : ORIGIN = 0x1F000C00, LENGTH = 0x000FF400  /* Remaining of 1 MB flash are free to be used for application*/
  RAM (rwx) : ORIGIN = 0x00100000, LENGTH = 0x60000 /* 384K */
}
