/*----------------------------------------------------------------------
File    : BSP.c
Purpose : BSP for Infineon XMC4500 eval board
--------  END-OF-HEADER  ---------------------------------------------
*/

#include "BSP.h"
#include <XMC4500.h>

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define LED0          14
#define LED1          15

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       BSP_Init()
*/
void BSP_Init(void) {
  //P2_IOCR12 &= (unsigned int)~0xFFFF0000;
  PORT2->IOCR12 &= (unsigned int)~0xFFFF0000;
  //P2_IOCR12 |= 0x80800000;
  PORT2->IOCR12 |= 0x80800000;
  //P2_OUT    &= ~((1ul << LED0) | (1uL << LED1));
  PORT2->OUT &= ~((1ul << LED0) | (1uL << LED1));
}

/*********************************************************************
*
*       BSP_SetLED()
*/
void BSP_SetLED(int Index) {
  if (Index == 0) {
    //P2_OUT |= (1uL << LED0);
    PORT2->OUT |= (1uL << LED0);
  } else if (Index == 1) {
    //P2_OUT |= (1uL << LED1);
    PORT2->OUT |= (1uL << LED1);
  }
}

/*********************************************************************
*
*       BSP_ClrLED()
*/
void BSP_ClrLED(int Index) {
  if (Index == 0) {
    //P2_OUT &= ~(1uL << LED0);
    PORT2->OUT &= ~(1uL << LED0);
  } else if (Index == 1) {
    //P2_OUT &= ~(1uL << LED1);
    PORT2->OUT &= ~(1uL << LED1);
  }
}

/*********************************************************************
*
*       BSP_ToggleLED()
*/
void BSP_ToggleLED(int Index) {
  if (Index == 0) {
    //P2_OMR |= (1uL << LED0) | (1uL << (LED0 + 16));
    PORT2->OMR |= (1uL << LED0) | (1uL << (LED0 + 16));
  } else if (Index == 1) {
    //P2_OMR |= (1uL << LED1) | (1uL << (LED1 + 16));
    PORT2->OMR |= (1uL << LED1) | (1uL << (LED1 + 16));
  }
}

/****** End Of File *************************************************/

