/*----------------------------------------------------------------------
File    : BSP.c
Purpose : BSP for Infineon XMC4500 eval board
--------  END-OF-HEADER  ---------------------------------------------
*/

#include "BSP.h"
#include <XMC4500.h>

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define LED0          9

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       BSP_Init()
*/
void BSP_Init(void) {
  PORT3->IOCR8 &= (unsigned int)~0x0000FF00;
  PORT3->IOCR8 |= 0x00008000;
  PORT3->OUT &= ~(1ul << LED0);
}

/*********************************************************************
*
*       BSP_SetLED()
*/
void BSP_SetLED(int Index) {
  if (Index == 0) {
    PORT3->OUT |= (1uL << LED0);
  }
}

/*********************************************************************
*
*       BSP_ClrLED()
*/
void BSP_ClrLED(int Index) {
  if (Index == 0) {
    PORT3->OUT &= ~(1uL << LED0);
  }
}

/*********************************************************************
*
*       BSP_ToggleLED()
*/
void BSP_ToggleLED(int Index) {
  if (Index == 0) {
    PORT3->OMR |= (1uL << LED0) | (1uL << (LED0 + 16));
  }
}

/****** End Of File *************************************************/

